/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.blockentity.barrel.mode;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.AbstractBarrelMode;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.BlockBarrelMode;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.CompostBarrelMode;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.EmptyBarrelMode;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.FluidTransformBarrelMode;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.FluidsBarrelMode;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.MobSpawnBarrelMode;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class BarrelModeRegistry {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());
    @Nonnull
    private static final Map<String, Supplier<AbstractBarrelMode>> modeNameMap = new HashMap<String, Supplier<AbstractBarrelMode>>();
    @Nonnull
    private static final Map<TriggerType, ArrayList<Supplier<AbstractBarrelMode>>> modeMap = new EnumMap<TriggerType, ArrayList<Supplier<AbstractBarrelMode>>>(TriggerType.class);

    @Nullable
    public static AbstractBarrelMode getModeFromName(@Nonnull String barrelMode) {
        return (AbstractBarrelMode)((Supplier)modeNameMap.getOrDefault(barrelMode, null)).get();
    }

    @Nonnull
    public static List<Supplier<AbstractBarrelMode>> getModes(@Nonnull TriggerType type) {
        logger.debug("Getting barrel mode, Trigger: " + type);
        return modeMap.get((Object)type);
    }

    public static void initialize() {
        logger.debug("Adding barrel modes");
        BarrelModeRegistry.addMode(() -> new EmptyBarrelMode("empty"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new CompostBarrelMode("compost"), TriggerType.ITEM);
        BarrelModeRegistry.addMode(() -> new FluidsBarrelMode("fluid"), TriggerType.ITEM);
        BarrelModeRegistry.addMode(() -> new BlockBarrelMode("block"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new MobSpawnBarrelMode("mob"), TriggerType.NONE);
        BarrelModeRegistry.addMode(() -> new FluidTransformBarrelMode("transform"), TriggerType.NONE);
    }

    public static void addMode(@Nonnull Supplier<AbstractBarrelMode> mode, @Nonnull TriggerType type) {
        logger.debug("Adding mode: " + mode + ", Trigger: " + type);
        ArrayList<Supplier<AbstractBarrelMode>> list = modeMap.get((Object)type);
        if (list == null) {
            list = new ArrayList();
        }
        list.add(mode);
        modeMap.put(type, list);
        modeNameMap.put(mode.get().getModeName(), mode);
    }

    public static enum TriggerType {
        ITEM,
        FLUID,
        NONE;

    }
}

